package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.objects.GenericObject;
import com.hero.objects.powers.Sense;
import com.hero.objects.powers.SenseGroup;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class SenseDialog extends PowerDialog {

	private static final long serialVersionUID = -3434669773489751150L;

	protected JLabel groupLbl;

	protected JComboBox groupCombo;

	protected JLabel groupValueLbl;

	protected JLabel activeLbl;

	protected JComboBox activeCombo;

	protected JLabel activeValueLbl;

	/**
	 * @param object
	 * @param isNew
	 * @param isPower
	 */
	public SenseDialog(Sense object, boolean isNew, boolean isPower) {
		super(object, isNew, isPower);
	}

	@Override
	protected JPanel getTopPanel() {
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);

		JPanel panel = super.getTopPanel();
		gbc.gridy = 22;
		panel.add(activeLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 1;
		gbc.gridwidth = 2;
		if (((Sense) object).isActiveSelectable()) {
			panel.add(activeCombo, gbc);
		} else {
			panel.add(activeValueLbl, gbc);
		}
		gbc.gridy = 23;
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.gridwidth = 1;
		gbc.weightx = 0;
		panel.add(groupLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 1;
		gbc.gridwidth = 2;
		if (((Sense) object).getAvailableGroups().size() > 1) {
			panel.add(groupCombo, gbc);
		} else {
			panel.add(groupValueLbl, gbc);
		}
		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		groupCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (groupCombo.getSelectedItem() != null) {
					SenseGroup group = (SenseGroup) groupCombo
							.getSelectedItem();
					((Sense) object).setGroup(group);
					GenericObject.lastEdit = System.currentTimeMillis();
					updateValues();
					layoutExtrasPanel();
				}
			}
		});
		activeCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (activeCombo.getSelectedItem() != null) {
					((Sense) object).setActive(activeCombo.getSelectedItem()
							.toString().equals("Active"));
					GenericObject.lastEdit = System.currentTimeMillis();
					updateValues();
					layoutExtrasPanel();
				}
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		groupLbl = new JLabel("Sense Group:");
		groupCombo = new JComboBox(((Sense) object).getAvailableGroups()
				.toArray());
		groupCombo.setSelectedItem(((Sense) object).getGroup());
		groupValueLbl = new JLabel(((Sense) object).getGroup().getDisplay());
		activeLbl = new JLabel("Type:");
		activeValueLbl = new JLabel(((Sense) object).isActive() ? "Active"
				: "Passive");
		String[] vals = { "Active", "Passive" };
		activeCombo = new JComboBox(vals);
		activeCombo.setSelectedItem(((Sense) object).isActive() ? "Active"
				: "Passive");
	}
}